package it.unitn.disi.ronchet.sudoku.cells;

import it.unitn.disi.ronchet.sudoku.Sudoku;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

/**
 * FreeCell è una cella caratterizzata dal fatto di avere 
 * un valore mutabile, appartenere a una regione, 
 * avere background che dipende dalla regione 
 * e di rispondere ai click mutando il proprio valore.
 * @author ronchet
 */
public class FreeCell extends Cell {
    int region;

    public FreeCell(int i, int j, Sudoku s) {
        super(i,j, s);
        region=s.validator.findRegion(i,j);
        background.setFill(s.colors[region]);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent event) {
                if (value!=0) {
                    // se la cella contiene già una valore rimuovilo
                    s.validator.remove(value, i, j);
                    nt.clear();
                    value=0;
                    s.setCount(s.getCount()+1);
                    return;
                } else {
                    int newValue=s.getChoiceBoxValue();
                    if (s.validator.add(newValue, i, j)) {
                        value=newValue;
                        nt.setValue(value);
                        int n=s.getCount()-1;
                        s.setCount(n);
                        if (n==0) s.declareVictory();
                    }
                }
            }
        });
    }
}
