package it.unitn.disi.ronchet.sudoku.cells;

import it.unitn.disi.ronchet.sudoku.Sudoku;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class UninitializedCell extends Cell {
/**
 * UninitializedCell è una cella caratterizzata dal fatto di 
 * non avere alcun valore, avere uno sfondo bianco e
 * di rispondere ai click sostituendo se stessa con una 
 * PredefinedCell. 
 * Inoltre quando un numero predefinito di PredefinedCells sono 
 * state create, invoca sulla griglia il metodo che inizializza 
 * le FreeCells.
 * @author ronchet
 */
    public UninitializedCell(int i, int j, Sudoku s) {
        super(i, j, s);
        background.setFill(Color.WHITE);
        UninitializedCell thisCell = this;
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent event) {
                if (s.numberOfFixedCellsToBeCreated > 0) {
                    boolean isOK = false;
                    int number = s.getChoiceBoxValue();
                    if (number != 0) {
                        if (s.validator.add(number, i, j)) {
                            PredefinedCell pc = new PredefinedCell(number, i, j, s);
                            grid.getChildren().remove(thisCell);
                            grid.add(pc, i, j);
                            s.numberOfFixedCellsToBeCreated--;
                            // quando hai creato tutte le celle fisse procedi
                            if (s.numberOfFixedCellsToBeCreated == 0) {
                                grid.generateFreeCells();
                            }
                        }
                    }
                }
            }
        });
    }
}
