/*
 * Decompiled with CFR 0.152.
 */
package lode_ronchet.grabber;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import lode_ronchet.grabber.LodeConfig;
import lode_ronchet.grabber.util.ClipboardCopier;
import lode_ronchet.grabber.util.ImageDecoder;
import lode_ronchet.grabber.util.JsonUtils;
import lode_ronchet.grabber.util.NetworkUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public final class Grabber {
    private BufferedImage image = null;
    public LodeConfig config = LodeConfig.getInstance();
    public String token = null;
    public String ip = null;
    private String lectureID = null;
    private String username = this.config.getUsername();
    private String password = this.config.getPassword();
    private String baseURL = this.config.getBaseURL();
    private String pin = null;
    private String machineIdentifier = null;

    public Grabber() {
        this.ip = this.config.getIp();
        this.pin = this.config.getPin();
        this.machineIdentifier = this.config.getMachineIdentifier();
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public final boolean login() {
        String url = this.baseURL + "/api/user/login";
        String response = null;
        JsonObject jsonObj = Json.createObjectBuilder().add("email", this.username).add("password", this.password).build();
        String jsonString = jsonObj.toString();
        Header[] headers = new Header[]{new BasicHeader("Accept", "application/json"), new BasicHeader("Content-type", "application/json")};
        try {
            response = NetworkUtils.sendPost(url, jsonString, headers);
        }
        catch (Exception ex) {
            Logger.getLogger(Grabber.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        if (response == null) {
            return false;
        }
        this.token = JsonUtils.getElementFromJson(response, "token");
        System.out.println("token is " + this.token);
        return true;
    }

    public final boolean identifyActiveLecture() {
        ArrayList<JsonValue> lectures = this.getLectures(true);
        if (lectures.isEmpty()) {
            System.err.println("No lectures are available");
            System.err.flush();
            this.lectureID = null;
            return false;
        }
        for (JsonValue l : lectures) {
            JsonObject lecture = (JsonObject)l;
            JsonObject _id = lecture.getJsonObject("_id");
            String machine = _id.getJsonNumber("machineIdentifier").toString();
            System.out.println("machineID is " + machine);
            if (!machine.equals(this.machineIdentifier)) continue;
            this.lectureID = JsonUtils.getElementFromJason(lecture, "uuid");
            return true;
        }
        return false;
    }

    private ArrayList<JsonValue> getLectures(boolean active) {
        String url = this.baseURL + "/api/lecture?live=" + active;
        String response = null;
        Header[] headers2 = new Header[]{new BasicHeader("Authorization", "Bearer " + this.token)};
        try {
            response = NetworkUtils.sendGet(url, headers2);
        }
        catch (Exception ex) {
            Logger.getLogger(Grabber.class.getName()).log(Level.SEVERE, null, ex);
        }
        JsonReader jsonReader = Json.createReader(new StringReader(response));
        JsonArray jsonArray = jsonReader.readArray();
        ArrayList<JsonValue> lectures = new ArrayList<JsonValue>();
        for (JsonValue jsonValue : jsonArray) {
            lectures.add(jsonValue);
            System.out.println(jsonValue);
        }
        System.out.println(lectures.size() + " lectures found");
        return lectures;
    }

    public final boolean copyScreenshot() {
        boolean success;
        JsonObject screenshotJO = this.getScreenShotAsJasonObject(this.lectureID, this.token);
        boolean bl = success = screenshotJO != null;
        if (success) {
            String image64 = screenshotJO.getString("img");
            String timestamp = screenshotJO.getString("timestamp");
            String fileName = screenshotJO.getString("fileName");
            System.out.println(fileName);
            System.out.println(timestamp);
            BufferedImage c = ImageDecoder.decodeToImage(image64);
            ClipboardCopier.copyImageToClipboard(c);
            this.image = c;
        }
        return success;
    }

    private JsonObject getScreenShotAsJasonObject(String lectureID, String token) {
        String url = this.baseURL + "/api/lecture/" + lectureID + "/screenshot";
        String response = null;
        Header[] headers3 = new Header[]{new BasicHeader("Authorization", "Bearer " + token), new BasicHeader("pin", this.pin)};
        try {
            response = NetworkUtils.sendGet(url, headers3);
        }
        catch (Exception ex) {
            Logger.getLogger(Grabber.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        JsonReader jsonReader = Json.createReader(new StringReader(response));
        JsonObject jsonObj = null;
        try {
            jsonObj = jsonReader.readObject();
        }
        catch (JsonParsingException ex) {
            jsonObj = null;
        }
        return jsonObj;
    }

    private void writeStringToFile(String s, String filePath) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filePath));
            out.write(s);
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Grabber.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

