/*
 * Decompiled with CFR 0.152.
 */
package lode_ronchet.grabber.gui;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.util.Date;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import lode_ronchet.grabber.Grabber;
import lode_ronchet.grabber.LodeConfig;
import lode_ronchet.grabber.gui.ConfigurationWindow;
import lode_ronchet.grabber.gui.NotificationWindow;

public final class LodeScreenshotGrabberGraphicApp
extends Application {
    Grabber grabber = null;
    LodeConfig config = null;
    NotificationWindow nw = null;
    ConfigurationWindow cw = null;
    ImageView iw = null;
    Stage primaryStage = null;
    int metaKey = 157;

    public void start(Stage primaryStage) {
        if (System.getProperty("os.name").startsWith("W")) {
            this.metaKey = 524;
        }
        this.config = LodeConfig.getInstance();
        this.grabber = new Grabber();
        this.iw = new ImageView();
        this.iw.setFitWidth(100.0);
        Button btn = new Button();
        this.setButtonAsConnect(btn);
        VBox root = new VBox();
        root.getChildren().addAll((Object[])new Node[]{btn, this.iw});
        Scene scene = new Scene((Parent)root, 70.0, 100.0);
        primaryStage.setTitle("Lode Grabber");
        primaryStage.setAlwaysOnTop(true);
        primaryStage.setScene(scene);
        primaryStage.setResizable(false);
        primaryStage.setX((double)this.config.getX());
        primaryStage.setY((double)this.config.getY());
        primaryStage.show();
        this.nw = new NotificationWindow(primaryStage);
        this.cw = new ConfigurationWindow(primaryStage);
        class DoubleChangeListener<Number>
        implements ChangeListener<Number> {
            String id = null;

            DoubleChangeListener(String s) {
                this.id = s;
            }

            public void changed(ObservableValue<? extends Number> ov, Number oldVal, Number newVal) {
                LodeScreenshotGrabberGraphicApp.this.config.update(this.id, ((Double)newVal).intValue());
            }
        }
        primaryStage.xProperty().addListener(new DoubleChangeListener("x"));
        primaryStage.yProperty().addListener(new DoubleChangeListener("y"));
    }

    private void clearThumbnail() {
        this.iw.setImage(null);
    }

    private void addThumbnail(BufferedImage tn) {
        WritableImage img = SwingFXUtils.toFXImage((BufferedImage)tn, null);
        this.iw.setImage((Image)img);
        this.iw.setPreserveRatio(true);
        this.iw.setFitWidth(100.0);
    }

    public static void main(String[] args) {
        LodeScreenshotGrabberGraphicApp.launch((String[])args);
    }

    private void setButtonAsConnect(final Button btn) {
        btn.setText("Connect");
        final LodeScreenshotGrabberGraphicApp me = this;
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!LodeScreenshotGrabberGraphicApp.this.grabber.login()) {
                    LodeScreenshotGrabberGraphicApp.this.showMessage("Unable to log in");
                    return;
                }
                if (!LodeScreenshotGrabberGraphicApp.this.grabber.identifyActiveLecture()) {
                    LodeScreenshotGrabberGraphicApp.this.showMessage("Unable to find active lecture");
                    return;
                }
                me.setButtonAsGrab(btn);
            }
        });
    }

    private void setButtonAsGrab(final Button btn) {
        btn.setText("Grab image");
        final LodeScreenshotGrabberGraphicApp me = this;
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    LodeScreenshotGrabberGraphicApp.this.clearThumbnail();
                    LodeScreenshotGrabberGraphicApp.this.switchFocus();
                    Date d1 = new Date();
                    if (!LodeScreenshotGrabberGraphicApp.this.grabber.copyScreenshot()) {
                        LodeScreenshotGrabberGraphicApp.this.showMessage("Unable to capture screenshot");
                        me.setButtonAsConnect(btn);
                    } else {
                        me.addThumbnail(LodeScreenshotGrabberGraphicApp.this.grabber.getImage());
                    }
                    Date d2 = new Date();
                    System.out.println(d2.getTime() - d1.getTime());
                }
                catch (Exception ex) {
                    LodeScreenshotGrabberGraphicApp.this.showMessage(ex.getMessage());
                }
            }
        });
    }

    private void showMessage(String msg) {
        System.err.println(msg);
        this.nw.setText(msg);
        this.nw.show(this);
    }

    void showConfiguration() {
        String msg = "username    : " + this.grabber.config.getUsername() + "\npin         : " + this.grabber.config.getPin() + "\nserver      : " + this.grabber.config.getIp() + "\nserver port : " + this.grabber.config.getPort() + "\nmachine id  : " + this.grabber.config.getMachineIdentifier() + "\n";
        this.cw.setText(msg);
        this.cw.show();
    }

    private void switchFocus() {
        try {
            Robot r = new Robot();
            r.keyPress(this.metaKey);
            r.keyPress(9);
            r.delay(10);
            r.keyRelease(this.metaKey);
            r.keyRelease(9);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }
}

