package tinyhttpd;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;


class TinyHttpdConnection extends Thread {

    Socket sock;

    TinyHttpdConnection(Socket s) {
        sock = s;
        setPriority(NORM_PRIORITY - 1);
        start();
    }

    public void run() {
        System.out.println("=========");
        OutputStream out = null;
        try {
            out = sock.getOutputStream();
            DataInputStream d = new DataInputStream(
                    sock.getInputStream());
            String req = d.readLine();
            System.out.println("Request: " + req);
            StringTokenizer st = new StringTokenizer(req);
            if ((st.countTokens() >= 2) && st.nextToken().equals("GET")) {
                if ((req = st.nextToken()).startsWith("/")) {
                    req = req.substring(1);
                }
                if (req.endsWith("/") || req.equals("")) {
                    req = req + "index.html";
                }

                try {
                    System.out.println("Looking for :" + req);
                    FileInputStream fis = new FileInputStream(req);
                    int dataLength=fis.available();
                    byte[] data = new byte[dataLength];
                    
                    PrintStream channel=new PrintStream(out);
                    channel.println("HTTP/1.1 200 OK\n"
                            + "Content-Type: text/html; charset=ISO-8859-1\n"
                            + "Connection: close \n"
                            //+ "Content-Range: * \n"
                            + "Content-Length: "+dataLength+"\n"
                            //+ "Content-Length: 0 \n"
                            //+ "Keep-Alive: timeout=0 \n"
                            );
                    channel.println(dataLength);
                    fis.read(data);
                    out.write(data);
                    channel.println("HELLO");
                    out.flush();
                    out.close();
                } catch (FileNotFoundException e) {
                    new PrintStream(out).println("HTTP/1.1 404 Not Found");
                    System.out.println("HTTP/1.1 404 Not Found: " + req);
                }

            } else {
                new PrintStream(out).println("HTTP/1.1 400 Bad Request");
                System.out.println("HTTP/1.1 400 Bad Request: " + req);
                out.flush();
                sock.close();

            }
        } catch (IOException e) {
            System.out.println("Generic I/O error " + e);
        } finally {
            try {
                out.flush();
                out.close();
            } catch (IOException ex) {
                System.out.println("I/O error on close" + ex);
            }
        }
    }
}
