package it.unitn.lingprogmod1.esercitaz3grafica;

/**
 * Classe che modella il contenuto del display e agisce su di esso
 * senza preoccuparsi di mostrarlo graficamente
 */
public class DisplayModel {
    /**
     * il valore contenuto nel display
     */
    String value;

    DisplayModel() {
        clear();
    }
    // we will never create mor than one instnce of this class
    //hence we do not need to create the equals method

    /**
     * cancella il contenuto del display e sostituiscilo con 0
     */    void clear(){
        value="0";
    }

    /**
     * modifica la stringa da mostrare nel display
     * *    ± cambia segno
     * *    C cancella
     * *    . aggiungi un  . decimale se non ne esiste già uno
     * *    cifra aggiungi la cifra
     * @param s il carattere che indica l'azione da compiere:
     *
     */
    void add(String s){
        if (s.equals("±")) changeSign();
        else if (s.equals(".")) addPoint();
        else if (s.equals("C")) clear();
        else addDigit(s);
        // da Java 7 si può usare lo switch anche con le stringhe.
        // quindi la catena di if.. else if di dopra può essere sostituita dal seguente codice:
        /*
        switch (s) {
            case "±":
                changeSign();
                break;
            case ".":
                addPoint();
                break;
            case "C":
                clear();
                break;
            default:
                addDigit(s);
        }
         */
        System.out.println(this);
    }
    // metodi provati che implementano la logica richiamata da add
    private void addDigit(String digit) {
        if (value.equals("0")) {
            value=digit;
        } else {
            value=value+digit;
        }
    }
    private void addPoint() {
        if (value.contains(".")) return;
        value=value+'.';
    }
    private void changeSign() {
        if (value.startsWith("-")) {
            value = value.substring(1);
        } else {
            if (!value.equals("0")) {
                value='-'+value;
            };
        }
    }
    @Override
    public String toString() {
        return "DisplayModel{" +
                "value='" + value + '\'' +
                '}';
    }

    /**
     * main program di test della classe
     */
    public static void main(String a[]){
        DisplayModel d=new DisplayModel();
        d.add("0");
        d.add("1");
        d.add("2");
        d.add(".");
        d.add(".");
        d.add("±");
        d.add("3");
        d.add("4");
        System.out.println(d);
        d.add("C");
        d.add("C");
        d.add("1");
        d.add("2");
        d.add(".");
        d.add("3");
        d.add(".");
        System.out.println(d);
    }
}
