package it.unitn.lingprogmod1.esercitaz3grafica;

import javafx.scene.control.TextField;

public class DisplayModel {
    // we will never create mor than one instnce of this class
    //hence we do not need to create the equals method
    /**
     * the value contained in the Display
     */
    private String value;
    private TextField display;
    private boolean newMode=true;

    DisplayModel(TextField display) {
        this.display=display;
        newMode=true;
        clear();
    }
    void enableNewMode() {
        newMode=true;
    }
    void setValue(double d) {
        value=Double.toString(d);
    }
    double getValueAsDouble(){
        double x=Double.parseDouble(value);
        return x;
    }
    void show(){
        if (display!=null) display.setText(value);
    }
    void clear(){
        value="0";
        newMode = false;
        show();
    }
    void add(String s){
        System.out.println(newMode + " " + value);
        if (s.equals("±")) changeSign();
        else {
            if (newMode) clear();
            if (s.equals("C")) clear();
            else if (s.equals(".")) addPoint();
            else addDigit(s);
        }
        show();
        System.out.println(this);
    }
    private void addDigit(String digit) {
        if (value.equals("0")) {
            value=digit;
        } else {
            value=value+digit;
        }
    }
    private void addPoint() {
        if (value.contains(".")) return;
        value=value+'.';
    }
    private void changeSign() {
        if (value.startsWith("-")) {
            value = value.substring(1);
        } else {
            if (!value.equals("0")) {
                value='-'+value;
            };
        }
    }

    @Override
    public String toString() {
        return "DisplayModel{" +
                "value='" + value + '\'' +
                '}';
    }

    public static void main(String[] a){
        DisplayModel d=new DisplayModel(null);
        d.add("0");
        d.add("1");
        d.add("2");
        d.add(".");
        d.add(".");
        d.add("3");
        d.add("4");
        System.out.println(d);
        d.add("C");
        d.add("C");
        d.add("1");
        d.add("2");
        d.add(".");
        d.add("3");
        d.add(".");
        System.out.println(d);
    }
}
