package it.unitn.lingprogmod1.esercitaz3grafica;

public class MemoryModel {
    double memory;
    char pendingOperation;
    DisplayModel d;

    MemoryModel(DisplayModel d) {
        memory=0;
        pendingOperation='=';
        this.d=d;
    }

    void setNewOperation(char c) {
        execPendingOperation();
        pendingOperation=c;
        d.setValue(memory);
        d.show();
        d.enableNewMode();
    }
    void execPendingOperation() {
        System.out.println("BEFORE: "+pendingOperation+" M:"+memory+" D:"+d.getValueAsDouble());
        switch (pendingOperation) {
            case '+':
                memory+=d.getValueAsDouble();
                break;
            case '-':
                memory-=d.getValueAsDouble();
                break;
            case '*':
                memory*=d.getValueAsDouble();
                break;
            case '/':
                memory/=d.getValueAsDouble();
                break;
            case '=':
                memory=d.getValueAsDouble();
                break;
            case '±': //change sign
                memory=-d.getValueAsDouble();
                break;
        }
        System.out.println("AFTER: "+pendingOperation+" M:"+memory+" D:"+d.getValueAsDouble());
    }
}
