package it.unitn.lingprog.esame2002;
import it.unitn.lingprog.esame2002.celle.*;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;

/**
 * Griglia del gioco
 *
 * @author ronchet
 */
public class Griglia extends GridPane implements EventHandler {

    final int N, N_1;
    Color color;
    Cella[][] caselle;
    public CellaBianca cellaBianca;
    Game game;
    boolean filterEvents=false;

    /**
     * Costruttore
     * @param n numero di celle per riga/colonna
     * @param cellController Controllore degli esenti di mouse per le caselle
     */
    public Griglia(int n, Game cellController)  {
        game =cellController;
        N = 5;
        N_1 = N - 1;
        this.setFilterEvents(false);
        this.addEventFilter(KeyEvent.KEY_TYPED, this);
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, this);
        caselle = new Cella[N][N];
        createSpecialCells();
        createNumericCells();
    }
    private void setFilterEvents(boolean filterEvents) {
        this.filterEvents=filterEvents;
    }
    private void createSpecialCells() {
        for (int i = 0; i < N_1; i++) {
            //aggiungi cella rossa in fondo alla colonna
            caselle[i][N_1] = new CellaRossa(i, N_1);
            caselle[i][N_1].setGriglia(this);
            this.add(caselle[i][N_1], i, N_1);
            //aggiungi cella verde in fondo alla riga
            caselle[N_1][i] = new CellaVerde(N_1, i);
            caselle[N_1][i].setGriglia(this);
            this.add(caselle[N_1][i], N_1, i);
        }
        cellaBianca=new CellaBianca(N_1,N_1);
        cellaBianca.setGriglia(this);
        caselle[N_1][N_1]=cellaBianca;
        this.add(cellaBianca, N_1, N_1);
    }

    private void createNumericCells() {
        for (int i = 0; i < N_1; i++) {
            for (int j = 0; j < N_1; j++) {
                boolean b = Game.RANDOM.nextBoolean();
                if (b) {
                    caselle[i][j] = new CellaViola(i, j);
                } else {
                    caselle[i][j] = new CellaGialla(i, j);
                }
                //aggiungi la casella alla griglia grafica
                this.add(caselle[i][j], i, j);
                caselle[i][j].setGriglia(this);
            }
        }
        updateCounters();
    }

    /**
     * aggiorna le caselle di somma e controlla la fine del gioco
     */
    private void updateCounters() {
        boolean righeHa10 = false;
        boolean colonneHa10 = false;
        for (int i = 0; i < N_1; i++) {
            caselle[i][N_1].setValue(getSumOfColumn(i));
            colonneHa10 = colonneHa10 || (caselle[i][N_1].getValue() == 10);
            caselle[N_1][i].setValue(getSumOfRow(i));
            righeHa10 = righeHa10 || (caselle[N_1][i].getValue() == 10);
        }
        if (righeHa10 || colonneHa10) { // almeno una condizione è verificata
            if (!righeHa10) {
                scriviMsg("Hai Perso");
            } else if (!colonneHa10) {
                scriviMsg("Hai vinto");
            } else {
                scriviMsg("Parita");
            }
            this.setFilterEvents(true);
        }
    }
    private void scriviMsg(String s) {
        System.out.println(s); // stampa in console
        // Apri un alert box
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("End of game");
        alert.setHeaderText(s);
        //alert.setContentText("no extra info");
        alert.showAndWait();
    }
    /**
     * restituisce la cella nelle coordinate date
     *
     * @param i riga (da 1 a 5)
     * @param j colonna (da 1 a 5)
     * @return cella individuata dalle coordinate.
     */
    public Cella getCellAt(int i, int j) {
        return caselle[i][j];
    }
    /**
     * Calcola la somma in una colonna
     * @param i colonna
     * @return somma
     */
    public int getSumOfColumn(int i) {
        int sum = 0;
        for (int j = 0; j < N_1; j++) {
            sum += getCellAt(i, j).getValue();
        }
        return sum;
    }
    /**
     * Calcola la somma in una riga
     * @param j riga
     * @return somma
     */
    public int getSumOfRow(int j) {
        int sum = 0;
        for (int i = 0; i < N_1; i++) {
            sum += getCellAt(i, j).getValue();
        }
        return sum;
    }

    public void modifyColumn(int posX) {
        for (int i = 0; i < N_1; i++) {
            getCellAt(posX, i).changeValue();
        }
        updateCounters();
    }

    public void modifyRow(int posY) {
        for (int i = 0; i < N_1; i++) {
            getCellAt(i, posY).changeValue();
        }
        updateCounters();
    }

    @Override
    public void handle(Event event) {
        System.out.println(event); //monitoraggio eventi
        if (filterEvents) {
            event.consume();
        }
    }
}

