package it.unitn.lingprog.esame2002.celle;

import it.unitn.lingprog.esame2002.Griglia;
import javafx.geometry.Insets;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
/**
 * Classe che rappresenta una cella generica
 * ha le proprieta grafiche e comuni ai sottotipi
 * @author ronchet
 */
public abstract class Cella extends StackPane {

    /**
     *
     */
    static public final int DIM=50;
    private int posX;
    private int posY;
    private int value;
    protected Rectangle square;
    protected Text cellLabel;
    Griglia griglia;
    /**
     * Costruttore
     * @param i coordinata della cella
     * @param j coordinata della cella
     * @param color colore della cella
     */
    public Cella(int i,int j, Color color, int value) {
        setPosX(i);
        setPosY(j);
        cellLabel=new Text("");
        setValue(value);
        square=new Rectangle(DIM-2,DIM-2);
        square.setFill(color);
        setMargin(square, new Insets(1,1,1,1));
        this.getChildren().add(square);
        this.getChildren().add(cellLabel);
    }
    /**
     * setter per associare la cella con la griglia che la contiene
     */
    public void setGriglia(Griglia g){
        griglia=g;
    }
    /**
     * metodo che caratterizza il comportamento della cella.
     * implementato a modo suo da ciascuna sottoclasse.
     */
    public abstract void changeValue();
    /**
     * setter - cambia il valore della cella
     */
    public void setValue(int v) {
        value=v;
        cellLabel.setText(""+value);
    }
    /**
     * getter
     * @return il valore della cella
     */    public int getValue() {
        return value;
    }

    //========= Metodi (setters & getters) di uso locale =========

    protected int getPosX() {return posX;}
    protected int getPosY() {return posY;}
    protected void setPosX(int k) {posX=k;}
    protected void setPosY(int k) {posY=k;}
}
