package it.unitn.lingprog.esame2002.celle;

import it.unitn.lingprog.esame2002.Game;
import javafx.scene.paint.Color;

/**
 * Superclasse per le celle gialle e viola che non rispondono ad eventi e si limitano a mostrare il proprio valore
 */
public abstract class CellaSoloNumerica extends Cella {
        int sign; // parametro per differenziare il comportamento dei due sottotipi
        public CellaSoloNumerica(int i, int j, Color color, int sign) {
            super(i,j, color, Game.RANDOM.nextInt(4));
            this.sign=sign;
        }
        @Override
        public void changeValue() {
            int delta=-1;
            if (griglia.cellaBianca.value.equals("+1")) delta=1;
            int val=getValue()+sign*delta;
            if (val>3) {
                val=0;
             } else if (val<0) {
                val = 3;
            }
            setValue(val);
            System.out.println(getValue()+" "+sign+" "+delta+" "+val);
        }
}
