package it.unitn.lingprogmod1.esercitaz2grafica;

import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class Carta {
    String valore;
    char seme;

    public Carta(String valore, char seme) {
        this.valore = valore;
        this.seme = seme;
    }

    @Override
    public String toString() {
        return "Carta{" +
                "valore=" + valore +
                ", seme=" + seme +
                '}';
    }

    boolean compare(Carta c) {
        return (this.seme==c.seme) && (this.valore == c.valore);
    }

    private String getImageName(){
        String filename=null;
        switch (seme) {
            case 'C':
                filename="Cuori.png";
                break;
            case 'Q':
                filename="Quadri.png";
                break;
            case 'F':
                filename="Fiori.png";
                break;
            case 'P':
                filename="Picche.png";
                break;
        }
        if (filename==null) return null;
        return filename;
    }
    public Node getGraphicCarta(){
        String filename = getImageName();
        Image image = new Image("file:src/" +
                filename, 80, 80, true, true);
        ImageView iw = new ImageView(image);
        Text t = new Text(valore);
        t.setFill(Paint.valueOf("YELLOW"));
        t.setFont(new Font(40));
        StackPane node = new StackPane(iw, t);
        return node;
    }
}
