package it.unitn.lingprogmod1.esercitaz2grafica;

import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Stage;

public class Main extends Application {

    @Override
    public void start(Stage primaryStage) throws Exception {
        int n = askUserForNumber(10);
        Mazzo m = new Mazzo();
        m.mescola();
        Mazzo mazzetto = new Mazzo(n, m);
        System.out.println(mazzetto);
        Carta c = mazzetto.trovaPrimaDoppia();
        String msg;
        boolean vittoria=true;
        if (c == null) {
            msg = "Spiacente, hai perso";
            vittoria=false;
        } else {
            Carta estratta=m.getRandom(n);
            if (estratta.seme==c.seme) {
                msg = "doppia vittoria con " + c + " e " + estratta;
            } else {
                msg = "vittoria semplice con " + c + " e " + estratta;
            }
        }
        showAlert(msg);
        if (vittoria) {
            Group root=new Group(c.getGraphicCarta());
            primaryStage.setTitle("Carta Vincente");
            primaryStage.setScene(new Scene(root, 100, 100));
            primaryStage.setX(400);
            primaryStage.setY(300);
            primaryStage.show();
        }
    }
    private String getImageName(char c){
        String filename=null;
        switch (c) {
            case 'C':
                filename="Cuori.png";
                break;
            case 'Q':
                filename="Quadri.png";
                break;
            case 'F':
                filename="Fiori.png";
                break;
            case 'P':
                filename="Picche.png";
                break;
        }
        if (filename==null) return null;
        return filename;
    }
    private int askUserForNumber(int default_n){
        int n=default_n;
        boolean error = true;
        do {
            TextInputDialog dialog = new TextInputDialog("" + default_n);
            dialog.setTitle("Gioco a carte");
            dialog.setHeaderText("Quante carte?");
            dialog.setContentText(":");
            String s = dialog.showAndWait().get();
            try {
                n = Integer.parseInt(s);
                error = false;
            } catch (NumberFormatException e) {
                error = true;
            }
        } while (error);
        return n;
    }
    private void showAlert(String msg) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Gioco a carte");
        alert.setHeaderText("Esito della partita:");
        alert.setContentText(msg);
        alert.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}

