package it.unitn.lingprogmod1.esercitaz2grafica;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;

public class Mazzo extends LinkedList<Carta> {
    String[] valore={"A","2","3","4","5","6","7","8","9","10","J","Q","K"};
    char[] seme={'C','Q','F','P'};
    public Mazzo() {
        //for (int i=1;i<=2;i++)
        for (String v : valore) {
            for (char s: seme) {
                Carta c = new Carta(v, s);
                this.add(c);
                this.add(c);
            }
        }
    }

    public Mazzo(int n, Mazzo m) {
        for (int i=0;i<n;i++) {
            this.add(m.get(i));
        }
    }
    void mescola() {
        Collections.shuffle(this);
    }

    @Override
    public String toString() {
        String s="Mazzo {\n";
        for (Carta c: this) {
              s = s + c.toString()+"\n";
        }
        s=s+'}';
        return s;
    }
    public Carta trovaPrimaDoppia(){
        for (Carta c: this) {
            if (indexOf(c)!=lastIndexOf(c)) {
                System.out.println("found at "+indexOf(c)+" "+lastIndexOf(c)+" : "+c.toString());
                return c;
            }
        }
        return null;
    }

    public Carta trovaPrimaDoppia(boolean traditional){
        int n=this.size();
        for (int i=0; i<n-1;i++) {
            Carta c1=this.get(i);
            for (int j=i+1; j<n; j++) {
                Carta c2=this.get(j);
                if (c1.compare(c2)) {
                    System.out.println("found at "+i+" "+j+" : "+c1.toString());
                    return c1;
                }
            }
        }
        for (Carta c: this) {
            if (indexOf(c)!=lastIndexOf(c)) {
                System.out.println("found at "+indexOf(c)+" "+lastIndexOf(c)+" : "+c.toString());
                return c;
            }
        }
        return null;
    }

    public Carta getRandom(int excluding) {
        Random r=new Random();
        int i=excluding+r.nextInt(this.size()-excluding);
        return get(i);
    }

    public static void main(String a[]){
        Mazzo m=new Mazzo();
        m.mescola();
        m.trovaPrimaDoppia();
        m.trovaPrimaDoppia(true);
    }
}
