package it.unitn.lingprog.esame2202;

import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public abstract class Figura extends StackPane {
    static final int RIGHT=0;
    static final int UP=1;
    static final int LEFT=2;
    static final int DOWN=3;

    public final static double INNER_RADIUS=20;
    Color fill= Color.BLUE;
    Shape s;

    /**
     * crea una figura con uno shape casuale scelto tra i tre possibili
     * @param tipo
     */
    Figura(int tipo){
        switch (tipo) {
            case 0: s=new Circle(0, 0, INNER_RADIUS); break;
            case 1: s=new Rectangle(0,0,INNER_RADIUS*2,INNER_RADIUS*2);; break;
            case 2: s=new Hexagon(); break;
        }
        this.getChildren().add(s);
    }

    /*@Override
    public String toString(){
        return (s.getClass().getName());
    }*/

    abstract void move(int dir);

    /**
     * riposiziona la figura corrente
     * @param dx
     * @param dy
     */
    void setPosition(int dx,int dy) {
        this.setTranslateX(dx);
        this.setTranslateY(dy);
    }
    double getX(){
        return this.getLayoutX()+this.getTranslateX();
    }
    double getY(){
        return this.getLayoutY()+this.getTranslateY();
    }
    /**
     * controlla se questa figura si trova a distanza di collisione con una figura data
     * @param f
     * @param collisionDistance
     * @return
     */
    boolean collides(Figura f, double collisionDistance)  {

        double dx=f.getX()-this.getX();
        double dy=f.getY()-this.getY();
        boolean collision= (dx*dx+dy*dy)<(collisionDistance*collisionDistance);
        if (collision) System.out.println(dx+" "+dy+" "+f+":"+this);
        return collision;
    }
}
