package it.unitn.lingprog.esame2202;

import java.util.ArrayList;
import java.util.Random;

import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Game extends Application implements EventHandler<KeyEvent> {
    final static int WINDOW_WIDTH = 500;
    //points constants
    final int INITIAL_POINTS = 500;
    final int MOVE_DECREMENT = -5;
    final int COLLISION_INCREMENT = 100;
    final int EXIT_DECREMENT = -50;

    public final static Random RANDOM = new Random(System.currentTimeMillis());

    int points = INITIAL_POINTS;
    ArrayList<Figura> list = new ArrayList<Figura>();
    Pane pane = new Pane();
    TextField pointsField = null;
    TextField displacementField = null;
    TextFieldHandler tfh = null;

    @Override
    public void start(Stage primaryStage) {
        BorderPane bp = new BorderPane();
        createFigures();
        bp.setCenter(pane);
        //
        ButtonHandler bh = new ButtonHandler(this);
        Button b_UP = new MyButton("SU", Figura.UP, bh);
        Button b_DOWN = new MyButton("GIU", Figura.DOWN, bh);
        Button b_LEFT = new MyButton("SINISTRA", Figura.LEFT, bh);
        Button b_RIGHT = new MyButton("DESTRA", Figura.RIGHT, bh);
        //
        // ======= Pannello Controllo
        HBox hb = new HBox();
        hb.setAlignment(Pos.CENTER);
        //
        displacementField = new TextField("10");
        tfh = new TextFieldHandler(displacementField);
        displacementField.setOnAction(tfh);
        VBox displacementBox = new VBox();
        displacementBox.getChildren().addAll(new Label("Spostamento"), displacementField);
        //
        pointsField = new TextField("" + INITIAL_POINTS);
        pointsField.setEditable(false);
        VBox pointsBox = new VBox();
        pointsBox.getChildren().addAll(new Label("Punti"), pointsField);
        //
        VBox vb = new VBox();
        vb.getChildren().addAll(b_UP, b_DOWN);
        hb.getChildren().addAll(displacementBox, b_LEFT, vb, b_RIGHT, pointsBox);
        bp.setBottom(hb);
        //
        Scene scene = new Scene(bp, WINDOW_WIDTH, WINDOW_WIDTH + 100);
        scene.setOnKeyTyped(this);
        primaryStage.setScene(scene);
        primaryStage.show();

    }

    /**
     * crea tre figure rosse e tre blu
     */
    void createFigures() {
        for (int i = 0; i < 3; i++) {
            int tipo = RANDOM.nextInt(3);
            Figura figura = new FiguraBlu(tipo, this);
            addToPanel(figura);
            list.add(figura);
            System.out.println(i + " " + figura);
            figura = new FiguraRossa(tipo);
            addToPanel(figura);
            list.add(figura);
            System.out.println(i + " " + figura);
        }
    }

    /**
     * disponi una figura nel pannello, controllando che non vi siano collisioni
     *
     * @param figura
     */
    private void addToPanel(Figura figura) {
        Figura colliding = null;
        do {
            int x = RANDOM.nextInt(400) + 50;
            int y = RANDOM.nextInt(400) + 50;
            figura.setPosition(x, y);
            colliding = checkCollisions(figura, 50);
        } while (colliding != null);
        pane.getChildren().add(figura);
        list.add(figura);
    }

    /**
     * controlla eventuali collisioni tra una figura data e tutte le (altre) figure già presenti
     *
     * @param figura
     * @param collisionDistance
     * @return
     */
    private Figura checkCollisions(Figura figura, int collisionDistance) {
        Figura colliding = null;
        // nota: iteriamo su un clone di list, perché list può essere modificato durante il ciclo
        for (Figura f : (ArrayList<Figura>) list.clone()) {
            if (f == figura) continue; //Avoid checking collisions with yourself
            boolean collision = figura.collides(f, collisionDistance);
            if (collision) return f;
        }
        return null;
    }

    /**
     * Durante gli spostamenti, in caso di collisione rimuovi entrambe le figure coinvolte
     *
     * @param figura
     * @return
     */
    private boolean manageCollisions(Figura figura) {
        Figura colliding = checkCollisions(figura, 50);
        boolean collisionHappened = (colliding != null);
        if (collisionHappened) {
            System.out.println(colliding);
            list.remove(figura);
            list.remove(colliding);
            pane.getChildren().remove(figura);
            pane.getChildren().remove(colliding);
            changePoints(COLLISION_INCREMENT);
        }
        return collisionHappened;
    }

    /**
     * controlla se una figura si trova fuori dai bordi, e se si eliminala
     *
     * @param f
     * @return
     */
    private boolean checkBoundaries(Figura f) {
        double xPos = f.getX();
        double yPos = f.getY();
        boolean exit = (xPos < 0 || xPos > WINDOW_WIDTH || yPos < 0 || yPos > WINDOW_WIDTH);
        if (exit) {
            list.remove(f);
            pane.getChildren().remove(f);
            changePoints(EXIT_DECREMENT);
        }
        return exit;
    }

    /**
     * gestisci gli eventi di tastiera, spostando le figure rosse individuate dal tasto premuto
     *
     * @param event
     */
    @Override
    public void handle(KeyEvent event) {
        System.out.println(event.getCharacter());
        String s = event.getCharacter();
        // nota: iteriamo su un clone di list, perché list può essere modificato durante il ciclo
        for (Figura f : (ArrayList<Figura>)(list.clone())) {
            if (f instanceof FiguraRossa) {
                FiguraRossa ff = (FiguraRossa) f;
                if (((FiguraRossa) f).letter.equalsIgnoreCase("" + event.getCharacter())) {
                    f.move(Figura.RIGHT);
                    boolean exit = checkBoundaries(f);
                    if (exit) continue; // proceed with next figure
                    boolean collisionHappened = manageCollisions(f);
                    if (collisionHappened) break; // the figure is not there any more, exit loop
                }
            }
        }
        changePoints(MOVE_DECREMENT);
    }

    /**
     * sposta tutte le figure blu nella direzione indicata da id
     *
     * @param id
     */
    public void moveBlueFigures(int id) {
        // nota: iteriamo su un clone di list, perché list può essere modificato durante il ciclo
        for (Figura f : (ArrayList<Figura>) (list.clone())) {
            if (f instanceof FiguraBlu) {
                f.move(id);
                // check boundaries
                boolean exit = checkBoundaries(f);
                if (exit) continue; // proceed with next figure
                // manage collisions
                manageCollisions(f);
            }
        }
        changePoints(MOVE_DECREMENT);
    }

    /**
     * modifica il punteggio corrente
     *
     * @param i
     */
    private void changePoints(int i) {
        points = points + i;
        pointsField.setText("" + points);
    }

    /**
     * trova il valore corrente di spostamento
     *
     * @return
     */
    int getDisplacementValue() {
        int x = 0;
        try {
            x = Integer.parseInt(displacementField.getText());
        } catch (NumberFormatException e) {
            displacementField.setText("0");
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "non puoi inserire caratteri non numerici", ButtonType.OK);
            alert.showAndWait();
        }
        return x;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
}


