package it.unitn.disi.ronchet.esameLuglio;

import it.unitn.disi.ronchet.esameLuglio.rotabili.*;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

import java.util.Collections;
import java.util.LinkedList;

public class Main extends Application {

    // un contenitore per i vari treni
    VBox trainsBox = new VBox();
    // lista dei treni in esercizio
    LinkedList<Treno> trainList = new LinkedList<Treno>();

    @Override
    public void start(Stage primaryStage) throws Exception {
        BorderPane root = new BorderPane();
        addTrains();
        drawTrains();
        root.setCenter(trainsBox);
        //
        // bottoni di ordinamento
        HBox buttonsBox = new HBox();
        Button orderByName = new Button("ordina per nome");
        orderByName.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                Collections.sort(trainList, new TrenoComparatorByName());
                drawTrains();
            }
        });
        Button orderByLenght = new Button("ordina per lunghezza");
        orderByLenght.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                Collections.sort(trainList);
                drawTrains();
            }
        });
        //
        // Bottone di stampa
        Button stampa = new Button("stampa");
        stampa.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                for (Treno t:trainList){
                    System.out.println(t);
                }
            }
        });
        buttonsBox.getChildren().addAll(orderByLenght, orderByName,stampa);
        root.setBottom(buttonsBox);
        //
        // gestione tasti L e N
        root.setOnKeyTyped(new EventHandler<KeyEvent>() {
            @Override
            public void handle(KeyEvent event) {
                String c = event.getCharacter();
                switch (c) {
                    case "l":
                    case "L": {
                        orderByLenght.fire();
                        break;
                    }
                    case "N":
                    case "n": {
                        orderByName.fire();
                        break;
                    }
                }
            }
        });
        //
        primaryStage.setTitle("Treni in esercizio di COGNOME NOME");
        primaryStage.setScene(new Scene(root, 1100, 375));
        primaryStage.show();
        primaryStage.setY(100);
        //
        // crea la seconda finestra
        SecondWindow win2=new SecondWindow(this);
        //posizionala opportunamente sullo schermo, in modo che le due finestre non si sovrappongano
        win2.setX(primaryStage.getX());
        win2.setY(primaryStage.getY()+400);
    }

    public void drawTrains() {
        trainsBox.getChildren().clear();
        for (Treno t : trainList) {
            VBox trainDisplay=t.getTrainDisplay();
            // gestisci i click del mouse sul traindisplay rimuovendo il treno
            trainDisplay.setOnMouseClicked(new EventHandler<MouseEvent>(){
                @Override
                public void handle(MouseEvent event) {
                    trainList.remove(t);
                    drawTrains();
                }
            });
            trainsBox.getChildren().add(trainDisplay);
        }
    }

    // setup iniziale treni
    private void addTrains() {
        // Poiche' ogni Treno e' un set ordinato, viene composto automaticamente in modo corretto
        Treno aurora = new Treno("Aurora");
        aurora.add(new Az());
        aurora.add(new Az());
        aurora.add(new Bz());
        aurora.add(new Bz());
        aurora.add(new Loco());
        trainList.add(aurora);
        //
        Treno colosseum = new Treno("Colosseum");
        colosseum.add(new Az());
        colosseum.add(new WRz());
        colosseum.add(new Dz());
        colosseum.add(new Bz());
        colosseum.add(new Bz());
        colosseum.add(new Loco());
        trainList.add(colosseum);
        //
        Treno mediolanum = new Treno("Mediolanum");
        mediolanum.add(new Az());
        mediolanum.add(new Az());
        mediolanum.add(new Az());
        mediolanum.add(new Loco());
        trainList.add(mediolanum);
    }

    public static void main(String[] args) {
        launch(args);
    }
}
