package it.unitn.disi.ronchet.esameLuglio;

import it.unitn.disi.ronchet.esameLuglio.rotabili.*;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class SecondWindow extends Stage {
    Main main = null;
    BorderPane root = new BorderPane();
    GridPane grid = new GridPane();
    Treno trenoInLavorazione = new Treno("nuovoTreno");

    SecondWindow(Main main) {
        this.main = main;
        this.setTitle("Officina di composizione");
        this.setY(500);
        //======================================================
        //Bottoni di aggiunta rotabili e relative azioni - versione 1
        // questa versione è più semplice ma più verbosa rispetto alla versione 2 usata sotto
        /*
        Button locoButton = new Button("Aggiungi Loco");
        locoButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                //trenoInLavorazione.add(new Loco());
                // potremmo scrivere una classe unica nella quale generare tu
                try {
                    trenoInLavorazione.add((Rotabile) (Class.forName("Loco").newInstance()));
                } catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                root.setBottom(trenoInLavorazione.getTrainDisplay());
            }
        });
        Button azButton = new Button("Aggiungi Az");
        azButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                trenoInLavorazione.add(new Az());
                root.setBottom(trenoInLavorazione.getTrainDisplay());
            }
        });
        Button bzButton = new Button("Aggiungi Bz");
        bzButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                trenoInLavorazione.add(new Bz());
                drawTrain();
            }
        });
        Button dzButton = new Button("Aggiungi Dz");
        dzButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                trenoInLavorazione.add(new Dz());
                drawTrain();
            }
        });
        Button wrzButton = new Button("Aggiungi WRz");
        wrzButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                trenoInLavorazione.add(new WRz());
                root.setBottom(trenoInLavorazione.getTrainDisplay());
            }
        });
        grid.add(locoButton, 0, 0);
        grid.add(azButton, 1, 0);
        grid.add(bzButton, 2, 0);
        grid.add(dzButton, 3, 0);
        grid.add(wrzButton, 4, 0);
        */
        // =======================================================
        //Bottoni di aggiunta rotabili e relative azioni - versione 2
        // fa riferimento alla classe interna AdderButton definita in fondo
        grid.add(new AdderButton("Loco"), 0, 0);
        grid.add(new AdderButton("Az"), 1, 0);
        grid.add(new AdderButton("Bz"), 2, 0);
        grid.add(new AdderButton("Dz"), 3, 0);
        grid.add(new AdderButton("WRz"), 4, 0);
        // =======================================================
        //
        // codice per l'inserimento del nome del treno
        grid.add(new Label("Nome del treno:"), 0, 1);
        TextField tf = new TextField();
        grid.add(tf, 0, 2, 3, 1);
        Button applicaNome = new Button("Applica:");
        applicaNome.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                trenoInLavorazione.setName(tf.getText());
                drawTrain();
            }
        });
        grid.add(applicaNome, 3, 2);
        //
        //messa in esercizio del treno composto
        Button mettiInEsercizio = new Button("metti in Esercizio:");
        mettiInEsercizio.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                main.trainList.add(trenoInLavorazione);
                trenoInLavorazione = new Treno("nuovoTreno");
                main.drawTrains();
                drawTrain();
            }
        });
        grid.add(mettiInEsercizio, 0, 3);
        //
        root.setCenter(grid);
        setScene(new Scene(root, 1100, 200));
        show();
    }

    private void drawTrain() {
        root.setBottom(trenoInLavorazione.getTrainDisplay());
    }

    class AdderButton extends Button {
        final String PACKAGE_NAME="it.unitn.disi.ronchet.esameLuglio.rotabili.";
        AdderButton(String tipo) {
            super("Aggiungi " + tipo);
            this.setOnAction(new EventHandler<ActionEvent>() {
                @Override
                public void handle(ActionEvent event) {
                    try {
                        trenoInLavorazione.add((Rotabile) (Class.forName(PACKAGE_NAME+tipo).newInstance()));
                    } catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                    root.setBottom(trenoInLavorazione.getTrainDisplay());
                }
            });
        }
    }
}

