package it.unitn.disi.ronchet.esameLuglio.rotabili;

import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public abstract class Rotabile implements Comparable<Rotabile>{
    int marcatura =0;

    protected abstract Image getImage();
    public ImageView getImageView() {
        ImageView iv = new ImageView();
        iv.setImage(getImage());
        return iv;
    }

    @Override
    public String toString(){
        return this.getClass().getSimpleName()+"-"+marcatura+":";
    }
    /**
     *  Implementiamo la comparazione sulla marcatura, cosicche' gli insiemi di Rotabili possano essere ordinati
     * @param o
     * @return
     */
    @Override
    public int compareTo(Rotabile o) {
        return marcatura -o.marcatura;
    }

}
