package it.unitn.disi.ronchet.esameLuglio.rotabili;

import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

import java.util.TreeSet;

/**
 * usando un TreeSet abbiamo la garanzia che l'insieme di Rotabili sia sempre ordinato
 * per questo Rotabile deve implementare Comparable
 * Aggiungiamo un ordinamento "naturale" tra i Treno basato sulla lunghezza
 * Implementiamo a parte un comparatore per ordinare un insieme di Treno per nome
 */
public class Treno extends TreeSet<Rotabile> implements Comparable<Treno>{
    String name=null;
    public Treno(String name){
        this.name=name;
    }
    public void setName(String name){
        this.name=name;
    }
    @Override
    public String toString(){
        StringBuffer retVal=new StringBuffer(name+": ");
        for (Rotabile i:this) {
            retVal.append(i.toString());
        }
        retVal.append("\n");
        return retVal.toString();
    }
    @Override
    public int compareTo(Treno o) {
        return this.size()-o.size();
    }
    /**
     * restituisce un HBox contenente le immagini dei rotabili che compongono il treno
     * @return
     */
    private HBox getTrainDrawing(){
        HBox hbox=new HBox();
        for (Rotabile i:this) {
            hbox.getChildren().add(i.getImageView());
        }
        return hbox;
    }

    /**
     * restituisce un VBox che contiene sulla prima riga il nome del treno, sulla seconda la sua rappresentazione grafica
     * @return
     */
    public VBox getTrainDisplay(){
        VBox trainDisplay=new VBox();
        Label trainName=new Label(name);
        trainName.setTextFill(Color.RED);
        trainName.setFont(new Font("Arial", 30));
        trainDisplay.getChildren().addAll(trainName, getTrainDrawing());
        return trainDisplay;
    }
}
