package it.unitn.ronchet.SSEdemo;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;

// Thread that waits for new item and then redistribute it
public class Distributor implements Runnable {
    
    // Store to keep new messages, yet to be distributed to clients
    //Queue with a blocking method: take()
    private BlockingQueue<NewsItem> newItemsQueue;
    // List of all open connections from browsers
    private Map<String, AsyncContext> clientList;
    // List of past messages
    private List<NewsItem> pastItemsList;
    private ServletContext ctx;
    private boolean running=false;
    Distributor(ServletContext ctx) {
        this.ctx=ctx;
        newItemsQueue=(BlockingQueue<NewsItem>)ctx.getAttribute("queue");
        pastItemsList=(List<NewsItem>)ctx.getAttribute("newsList");
        clientList=(Map<String, AsyncContext>)ctx.getAttribute("clients");
    }
    void start() {
        running=true;
        Thread t= new Thread(this);
        t.start();
        ctx.log("started distributor");
    }
    void stop() {
        running=false;
        ctx.log("stopped distributor");
    }    
    @Override
    public void run() {
        while (running) {
            try {
                // Waits until a news_item arrives
                NewsItem news_item = newItemsQueue.take();
                ctx.log("got new message :"+news_item);
                // Store into past items, for futore clients
                pastItemsList.add(news_item);
                // Sends the item to all the clients
                // we use an iterator instead of a for : loop to be allowed
                // to modify the set
                Iterator<AsyncContext> iter=clientList.values().iterator();
                while (iter.hasNext()) {
                    AsyncContext client=iter.next();
                    try {
                        PrintWriter channel = client.getResponse().getWriter();
                        sendMessage(channel, news_item);
                    } catch (Exception e) {
                        /* In case of problems remove context from map */
                        iter.remove();
                    }
                }
            } catch (InterruptedException e) {/* Log exception, etc.*/}
        }
    }
    /**
     * Sends messages to client in SSE format.
     *
     * @param writer
     * @param item
     */
    private void sendMessage(PrintWriter writer, NewsItem item) {
        writer.print("data: ");
        writer.println(item.toJSON());
        writer.println();
        writer.flush();
    }
}

