package it.unitn.ronchet.SSEdemo;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "NewsChannelOpenerServlet", urlPatterns = {"/NewsChannelOpenerServlet"}, asyncSupported=true)
public class NewsChannelOpenerServlet extends HttpServlet {

    ServletContext ctx;
    private AtomicLong counter = new AtomicLong();

    // Keep a list of all open connections from browsers
    private Map<String, AsyncContext> clientList;

    //private DistributorRunnable distributor;
    void addReader(HttpServletRequest request,HttpServletResponse response) {
        // Create a unique identifier for the client
        final String id = UUID.randomUUID().toString();
        // Start asynchronous context and add listeners
        final AsyncContext ac = request.startAsync(request, response);
        ac.addListener(new AsyncListener() {
            // implement all methods required by the AsyncListener interface
            @Override
            public void onStartAsync(AsyncEvent event) throws IOException {
                // Do nothing
            }            
            //in case of completion, error ot timeout remove client
            @Override
            public void onComplete(AsyncEvent event) throws IOException {
                clientList.remove(id);
            }
            @Override
            public void onError(AsyncEvent event) throws IOException {
                clientList.remove(id);
            }
            @Override
            public void onTimeout(AsyncEvent event) throws IOException {
                clientList.remove(id);
            }
        });
        // Put context in a map
        clientList.put(id, ac);
        log("added new client");
    }
// ================= SERVLET MAIN METHODS ==================================
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        log(" INIT =============================");
        ctx = getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getHeader("Accept").equals("text/event-stream")) {
            // setup resonse headers
            response.setContentType("text/event-stream");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Connection", "keep-alive");
            response.setCharacterEncoding("UTF-8");
            // This a Tomcat specific - makes request asynchronous
            request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", true);            clientList = (Map<String, AsyncContext>) ctx.getAttribute("clients");
            //
            addReader(request,response);
        } else {
            response.getWriter().println("Sorry, event stream not supported");
        }
    }
}
