package it.unitn.ronchet.SSEdemo;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "NewsFeederServlet", urlPatterns = {"/NewsFeederServlet"})
public class NewsFeederServlet extends HttpServlet {
    ServletContext ctx;
    private AtomicLong counter = new AtomicLong();
    
    // Keep a list of all open connections from browsers
    private Map<String, AsyncContext> clientList;

    // Temporary store for messages when arrived
    //Queue with a blocking method: take()
    private BlockingQueue<NewsItem> newItemsQueue;

    // Keep last messages
    private List<NewsItem> pastItemsList;

    private Distributor distributor;
    // ================= SERVLET MAIN METHODS ==================================
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        log(" INIT =============================");
        ctx=getServletContext();
        startEvent();
    }
    private void startEvent(){
        // create all needed items, add them to context, start the distributor
        counter.set(0);
        newItemsQueue=new LinkedBlockingQueue<NewsItem>();
        ctx.setAttribute("queue", newItemsQueue);
        clientList=new ConcurrentHashMap<String, AsyncContext>();
        ctx.setAttribute("clients", clientList);
        pastItemsList=new CopyOnWriteArrayList<NewsItem>();
        ctx.setAttribute("newsList", pastItemsList);
        distributor=new Distributor(ctx);
        ctx.setAttribute("distributor", distributor);
        distributor.start();       
    }
    private void endEvent(){
        // Stops thread, clearsthe stores and remove everything
        distributor.stop();
        clientList.clear();
        newItemsQueue.clear();
        pastItemsList.clear();
        ctx.removeAttribute("queue");
        ctx.removeAttribute("clients");        
        ctx.removeAttribute("distributor");
        newItemsQueue=null;
        clientList=null;
        distributor=null;
    }
    /**
     * Receives messages from writer. Verify newsLine, and put it into newItemsQueue.
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (ctx.getAttribute("queue")==null) startEvent(); 
        // Sets char encoding - should not be done here, better in filter
        request.setCharacterEncoding("UTF-8");
        // Gets newsLine from request
        String newsLine = request.getParameter("line");
        log("got news item " + newsLine);
        if ((newsLine != null) && !newsLine.trim().isEmpty()) {
            if (newsLine.compareTo("%END%")==0){
                endEvent();
                request.getRequestDispatcher("/newsCreator.jsp").forward(request, response); 
                return;
            }
            try {
                // Create NewsItem
                NewsItem news_item = new NewsItem(counter.incrementAndGet(), newsLine.trim());
                // Put newsLine into newItemsQueue
                newItemsQueue.put(news_item);
            } catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        request.getRequestDispatcher("/newsCreator.jsp").forward(request, response); 
    }
    @Override
    public void destroy() {
        endEvent();
    }
}
