package it.unitn.disi.ronchet.HitCounter;

import java.io.*;
import javax.servlet.ServletException;
import javax.servlet.http.*;
import javax.servlet.annotation.*;

@WebServlet(name = "ConterDemoServlet", value = "/demoServlet")
public class CounterDemoServlet extends HttpServlet {
    Counter counter;

    @Override
    public void init() {
        File f = new File("/Users/ronchet/Download/counterData"); //update with your path!
        try {
            if (!f.exists()) {
                f.createNewFile();
                counter = new Counter();
                ObjectOutputStream oi = new ObjectOutputStream(new FileOutputStream(f));
                oi.writeObject(counter);
                log("created file");
            } else {
                ObjectInputStream oi = new ObjectInputStream(new FileInputStream(f));
                counter = (Counter) oi.readObject();
                log("read file");
            }
        } catch (IOException | ClassNotFoundException e) { // bad exception catching
            log("problem encountered");
            e.printStackTrace();
        }
        log(counter.toString());
    }

    @Override
    public void destroy() {
        File f = new File("/Users/ronchet/Download/counterData");
        try (ObjectOutputStream oi = new ObjectOutputStream(new FileOutputStream(f))) {
            oi.writeObject(counter);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    public void log(String msg) {
        getServletContext().log(msg);
    }

    @Override
    protected void doGet(HttpServletRequest request,
                         HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=UTF-8");
        try (PrintWriter out = response.getWriter()) {
            request.getRequestDispatcher("/fragment1.html")
                    .include(request, response);
            out.println("here");
            counter.increase();
            out.println(counter);
            out.println("there");
            request.getRequestDispatcher("/fragment2.html")
                    .include(request, response);
        }
    }
}