package it.unitn.ronchet.jndiaccesstormiregistry;

import javax.naming.*;
import javax.naming.directory.InitialDirContext;
import java.util.Properties;

public class AccessRMIregistry {
    public static void main(String[] args) {
        new AccessRMIregistry();
    }
    public AccessRMIregistry() {
// Identify service provider to use
        Properties env = new Properties();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.rmi.registry.RegistryContextFactory");
        env.put(Context.PROVIDER_URL, "rmi://localhost:1099");
        CompositeName cn = null;
        try {
            cn = new CompositeName("foo");
        } catch (InvalidNameException ex) {
            perr(ex, "Invalid name!");
        }
        LinkRef lr = new LinkRef(cn);
        Context ctx = null;
        try {
            ctx = new InitialDirContext(env);
        } catch (NamingException ex) {
            perr(ex, "Invalid InitialDirContext!");
        }
        String name = "myVar3";
        try {
            Object o = ctx.lookup(name);
        } catch (NamingException ex) {
            System.out.println(name + " is not registered");
            try {
                ctx.bind(name, lr);
            } catch (NamingException ex1) {
                perr(ex, "Unable to bind " + name);
            }
        }
        LinkRef result = null;
        try {
            result = (LinkRef) ctx.lookup(name);
        } catch (NamingException ex) {
            perr(ex, "Unable to lookup " + name);
        }
        try {
            System.out.println(result.getLinkName());
        } catch (NamingException ex) {
            perr(ex, "Unable to get name from LinkRef ");
        }
        try {
            ctx.close();
        } catch (NamingException ex) {
            perr(ex, "Error on close");
        }
        System.exit(0);
    }
    private static void perr(Exception ex, String message) {
        System.out.println(message);
        ex.printStackTrace();
        System.exit(1);
    }
}
