package it.unitn.ronchet.distributedobjectdemo.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class Person_Skeleton extends Thread {
    PersonServer myServer;
    int port = 9000;

    public Person_Skeleton(PersonServer server) {
        this.myServer = server;
    }

    public void run() {
        Socket socket = null;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
        } catch (IOException ex) {
            System.err.println("error while creating serverSocket");
            ex.printStackTrace(System.err);
            System.exit(1);
        }

        while (true) {
            try {
                socket = serverSocket.accept();
                System.out.println("Client opened connection");
            } catch (IOException ex) {
                System.err.println("error accepting on serverSocket");
                ex.printStackTrace(System.err);
                System.exit(1);
            }
            // keep reading as long as there are available data
            while (socket != null) {
                ObjectInputStream instream = null;
                try {
                    try {
                        instream = new ObjectInputStream(socket.getInputStream());
                    } catch (EOFException ex) {
                        System.out.println("Client closed connection");
                        socket.close();
                        break;
                    }
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
                String method = null;
                try {
                    method = (String) instream.readObject();
                } catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                if (method.equals("age")) {
                    int age = myServer.getAge();
                    try {
                        ObjectOutputStream outstream =
                                new ObjectOutputStream(socket.getOutputStream());
                        outstream.writeInt(age);
                        outstream.flush();
                    } catch (IOException ex) {
                        ex.printStackTrace();
                        System.exit(1);
                    }
                } else if (method.equals("name")) {
                    String name = myServer.getName();
                    try {
                        ObjectOutputStream outstream =
                                new ObjectOutputStream(socket.getOutputStream());
                        outstream.writeObject(name);
                        outstream.flush();
                    } catch (IOException ex) {
                        ex.printStackTrace();
                        System.exit(1);
                    }
                }
            }

        }//end of while(true)
    }  //end of run method
}    //end of class

