package it.unitn.ronchet.rmi.rmidemo.client;

import it.unitn.ronchet.rmi.rmidemo.RMIInterface;
import it.unitn.ronchet.rmi.rmidemo.server.ServerOperation;

import javax.swing.*;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class ClientOperation {
    private static RMIInterface remoteObj;
    public static void main(String[] args) {
        try {
            remoteObj = (RMIInterface) Naming.lookup("rmi://localhost:"+ ServerOperation.port +"/MyServer");
        } catch (NotBoundException e) {
            System.out.println("ServerOperation object not present in registry");
            System.exit(1);
        } catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(2);
        } catch (RemoteException e) {
            System.out.println("Unable to access registry");
            System.exit(3);
        }
        String txt = JOptionPane.showInputDialog("What is your name?");
        String response = null;
        try {
            response = remoteObj.helloTo(txt);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog(null, response);
    }
}
