package it.unitn.ronchet.rmi.rmidemo.server;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;

import it.unitn.ronchet.rmi.rmidemo.RMIInterface;


public class ServerOperation extends UnicastRemoteObject implements RMIInterface, Serializable {
    private static final long serialVersionUID = 1L;
    public static final int port = 899;

    protected ServerOperation() throws RemoteException {
        super();
    }

    @Override
    public String helloTo(String name) throws RemoteException {
        System.out.println(name + " is contacting us!");
        return "Server says hello to " + name;
    }

    public static void main(String[] args) {
        //check if registry is running, else start it
        verifyRegistryAccessibility(port);
        // create and bind ServerOperation object
        try {
            Naming.rebind("//localhost:" + port + "/MyServer", new ServerOperation());
        } catch (RemoteException remoteException) {
            System.out.flush();
            System.err.println("REMOTE EXCEPTION");
            System.err.flush();
            remoteException.printStackTrace();
        } catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        System.out.println("Server is ready");
    }
    // ================================================================
    static void verifyRegistryAccessibility(int port) {
        if (!isRegistryAccessible(port)) {
            System.out.println("Registry is not running : starting it");
            startRegistry(port);
            if (!isRegistryAccessible(port)) {
                System.out.println("Registry: starting it");
                startRegistry(port);
                if (!isRegistryAccessible(port)) {
                    System.out.println("Still unable to access registry: exiting");
                    System.exit(1);
                }
            }
        }
    }
    // since there is no way to check if the registry is running,
    // to verify it it's there we try binding a dummy object into it
    static boolean isRegistryAccessible(int port) {
        try {
            class NullObject extends UnicastRemoteObject {
                protected NullObject() throws RemoteException {
                }
            }
            UnicastRemoteObject nullObject = new NullObject();
            Naming.rebind("//localhost:" + port + "/nullObject", nullObject);
        } catch (RemoteException e) {
            System.err.println("Registry in NOT accessible");
            return false;
        } catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        System.out.println("Registry in accessible now");
        return true;
    }

    static void startRegistry(int port) {
        try {
            LocateRegistry.createRegistry(port);
        } catch (RemoteException remoteException) {
            System.out.println("Unable to create Registry in startRegistry");
            remoteException.printStackTrace();
            System.exit(1);
        }
    }
}
